# Тестовое задание на позицию Data Analyst

Во вложении Вы получили SQLite3 базу данных со случайной выборкой из free-to-play игры «Мир Кораблей». Выполните задания ниже, используя любые инструменты для анализа и визуализации данных на ваше усмотрение.

## Исходные данные

### 1. Таблица `arenas`
Характеристики боя (режим, карта, длительность и т.п.)

| Столбец           | Комментарий                                                             |
|-------------------|-------------------------------------------------------------------------|
| arena_id          | Уникальный ID боя                                                       |
| periphery_id      | Уникальный ID кластера                                                 |
| winner_team_id    | ID команды-победителя, -1 означает ничью                               |
| start_dt          | Время начала боя                                                       |
| duration_sec      | Продолжительность боя (в секундах)                                     |
| map_type_id       | ID игровой карты (ref catalog_items, категория ‘ARENA_TYPES’)          |
| team_build_type_id| ID игрового режима (ref catalog_items, категория ‘TEAM_BUILD_TYPE’)    |
| battle_level_id   | ID уровня боя (обычно максимальный уровень корабля в бою)              |

### 2. Таблица `arena_members`
Данные по пользователям в сыгранных боях: техника игрока, успехи в бою и т.п. Отрицательные значения ID игроков соответствуют ботам.

| Столбец           | Комментарий                                                             |
|-------------------|-------------------------------------------------------------------------|
| arena_id          | Уникальный ID боя                                                       |
| periphery_id      | Уникальный ID кластера                                                 |
| account_db_id     | ID игрока. Отрицательный ID - игроки, управляемые ИИ (боты)            |
| team_id           | Команда игрока, обычно 0 или 1                                         |
| clan_db_id        | ID клана                                                               |
| vehicle_type_id   | Идентификатор используемого корабля                                    |
| ships_killed      | Количество уничтоженных вражеских кораблей                             |
| planes_killed     | Количество уничтоженных вражеских самолетов                            |
| damage            | Урон, нанесенный вражеским кораблям                                    |
| team_damage       | Урон, нанесенный по союзникам                                          |
| received_damage   | Урон, полученный в бою                                                 |
| regen_hp          | Восстановленное здоровье                                               |
| max_hp            | Максимальный объем здоровья корабля                                    |
| is_alive          | 1 – если корабль игрока «выжил к концу боя»                            |
| distance          | Проделанный путь                                                       |
| credits           | Заработанные кредиты                                                   |
| exp               | Заработанный опыт                                                      |

### 3. Таблица `glossary_ships`
Словарь для расшифровки техники.

### 4. Таблица `catalog_items`
Словарь для расшифровки других игровых сущностей (например, игрового режима).

## Часть 1. Анализ игровых логов

### Задание 1.1
Проанализируйте популярность игровых режимов (`team_build_type_id` из таблицы `arenas`) среди игроков и визуализируйте наблюдения. Объясните выбранный подход к анализу и визуализации.

### Задание 1.2
Проанализируйте показатели эффективности кораблей, выбрав методологию на ваш взгляд. Визуализируйте результаты и объясните выбор методологии.

## Часть 2. Разработка SQL-запросов

### Задание 2.1
Определите топ 5% игроков по суммарному урону за все бои. Запрос должен возвращать таблицу:

| account_db_id | total_damage |
|---------------|--------------|
|               |              |

### Задание 2.2
Для каждого игрока из задания 2.1 определите корабль, на котором он нанес больше всего урона за все бои. Ограничьте выгрузку 10-ю лучшими результатами. Запрос должен возвращать таблицу:

| account_db_id | ship_name | dealt_damage |
|---------------|-----------|--------------|
|               |           |              |

## Оформление результатов

- Результаты заданий части 1 оформить в PDF-отчете для менеджмента. Приложить отдельный архив с кодом.
- Результаты заданий части 2 предоставить в виде текстового файла с SQL-запросами.
